{**********************************************************************
{*
{* Teach uMenu -- Version 3.0  (implementation)
{*
{* Copyright (c)
{* Apple Computer, Inc.  1986-1989
{* All Rights Reserved.
{*
{* Developer Technical Support Apple II Sample Code
{*
{* This file contains the code which implements 
{* menus in the Teach program.
{*
{**********************************************************************}
{$R-}


PROCEDURE Debug;  INLINE $0000;


{*********************************************************************
* doQuitItem
*
* Just set the quitFlag -- that will do it.
*
*********************************************************************}
procedure doQuitItem;

   begin   {of doQuitItem}
       quitFlag := true;
   end;    {of doQuitItem}


{*********************************************************************
* doAboutItem
*
* Display the vanity box.
*
*********************************************************************}
procedure doAboutItem;
    var
        ignore : integer;
   begin   {of doAboutItem}
        ignore := AlertWindow(refIsResource * 2,NIL,Ptr(1));
   end;    {of doAboutItem}



{*********************************************************************
* doSelectAll
*
* Tell TextEdit to select all the text for the front window.
*
*********************************************************************}
procedure doSelectAll;
    var     
        thisHndl : CtlRecHndl;
        
   begin   {of doSelectAll}
        { Get the handle to the TE control for the top window }
        thisHndl := GetCtlHandleFromID(FrontWindow,MainWindowID);
        
        TESetSelection(0,$FFFFFFFF,TERecordHndl(thisHndl));     
   end;    {of doSelectAll}



{*********************************************************************
* doChooseFont
*
* Use ChooseFont to select a different font, and then have TextEdit
* change the selected text in the top window.
*
*********************************************************************}
procedure doChooseFont;
    var
        ignore      : integer;
        thisStyle   : TEStyle;
        tempHndl    : handle;
        thisHndl    : ctlRecHndl;
        
   begin   {of doChooseFont}
        { Create a Temporary handle for GetSelection Style }
        tempHndl := NewHandle (20,userID,0,NIL);
        
        { Get the handle to the TE control for the top window }
        thisHndl := GetCtlHandleFromID(FrontWindow,MainWindowID);
        
        { Get the current font of the selection }
        ignore := TEGetSelectionStyle(thisStyle,TEStyleGroupHndl(tempHndl),TERecordHndl(thisHndl));
        
        { Use it as the default for ChooseFont }
        thisStyle.styleFontID := ChooseFont(thisStyle.styleFontID,0);

        { Set font to user's choice }
        TEStyleChange(teReplaceFont+teReplaceSize+teReplaceAttributes,
            thisStyle,TERecordHndl(thisHndl));
        
        { Get rid of the handle }
        DisposeHandle (TempHndl);
   end;    {of ChooseFont}

{*********************************************************************
* doSetFont
*
* Change the family number for the selected text for the top window.
*
*********************************************************************}
procedure doSetFont   (theFam : integer);
    var
        thisStyle : TEStyle;
        thisHndl  : CtlRecHndl;
        
   begin   {of DoSetFont}
        { Get the handle to the TE control for the top window }
        thisHndl := GetCtlHandleFromID(FrontWindow,MainWindowID);
        
        thisStyle.styleFontID.FamNum := theFam;
        
        { Set font to user's choice }
        TEStyleChange(teReplaceFont,thisStyle,TERecordHndl(thisHndl));
   end;    {of DoSetFont}

{*********************************************************************
* doSetSize
*
* Change the font size for the selected text for the top window.
*
*********************************************************************}
procedure DoSetSize   (theSize : integer);
    var
        thisStyle : TEStyle;
        thisHndl  : CtlRecHndl;
        
   begin   {of DoSetSize}
        { Get the handle to the TE control for the top window }
        thisHndl := GetCtlHandleFromID(FrontWindow,MainWindowID);
                
        thisStyle.styleFontID.fontSize := theSize;
        
        { Set font to user's choice }
        TEStyleChange(teReplaceSize,thisStyle,TERecordHndl(thisHndl));
   end;    {of DoSetSize}


{*********************************************************************
* doSetStyle
*
*********************************************************************}
procedure DoSetStyle   (theStyle : integer);
    var
        thisStyle : TEStyle;
        thisHndl  : CtlRecHndl;
        
   begin   {of DoSetSize}
        { Get the handle to the TE control for the top window }
        thisHndl := GetCtlHandleFromID(FrontWindow,MainWindowID);
                
        thisStyle.styleFontID.fontStyle := theStyle;
        
        { Set font to user's choice }
        if theStyle = 0 
            then TEStyleChange(teReplaceAttributes,thisStyle,TERecordHndl(thisHndl))
            else TEStyleChange(teSwitchAttributes,thisStyle,TERecordHndl(thisHndl));
   end;    {of DoSetSize}



procedure DoMenu;

   {Procedure to handle all menu selections.  Examines the Event.TaskData
    menu item ID word from TaskMaster (from Event Manager) and calls the
    appropriate routine.  While the routine is running the menu title is
    still highlighted.  After the routine returns, we unhilight the
    menu title.}

   var menuNum, itemNum : integer;

   begin   {of DoMenu}

       menuNum := HiWord (event.wmTaskData);
       itemNum := LoWord (event.wmTaskData);
   
       case itemNum of
           AboutItem        :  doAboutItem;
           CloseItem        :  doCloseTop;
           QuitItem         :  doQuitItem;
           UndoItem         :  { Handled by taskmaster };
           CutItem          :  { Handled by taskmaster };
           CopyItem         :  { Handled by taskmaster };
           PasteItem        :  { Handled by taskmaster };
           ClearItem        :  { Handled by taskmaster };
           SelectAllItem    :  doSelectAll;
           NewItem          :  doNewWindow;
           OpenItem         :  doOpenWindow;
           SaveItem         :  doSave;
           SaveAsItem       :  doSaveAs;
           PageSetupItem    : ;
           PrintItem        :  ;
           PlainItem        : doSetStyle(0);
           BoldItem         : doSetStyle(boldMask);
           ItalicItem       : doSetStyle(italicMask);
           UnderlineItem    : doSetStyle(underlineMask);
           ShadowItem       : doSetStyle(shadowMask);
           OutlineItem      : doSetStyle(outlineMask);
           Size8Item        : doSetSize(8);
           Size10Item       : doSetSize(10);
           Size12Item       : doSetSize(12);
           Size16Item       : doSetSize(16);
           Size20Item       : doSetSize(20);
           Size24Item       : doSetSize(24);
           
           ChooseFontItem   : doChooseFont;
       otherwise
           if ItemNum >= FirstFontItem then doSetFont(ItemID2FamNum(itemNum));
       end;

       HiliteMenu (false,menuNum);     {Unhighlight the menu title}

   end;    {of DoMenu}



procedure SetUpMenus;

   {Procedure to install our menu titles and their items in the system menu
    bar and to redraw it so we can see them.}

   var height : integer;

   begin   {of SetUpMenus}
        SetSysBar(NewMenubar2(refIsResource,Ref(1),NIL));
        SetMenuBar(NIL);
        
        FixAppleMenu (AppleMenuID);               {Add DAs to apple menu    }
        
        FixFontMenu(FontMenuID,FirstFontItem,0);
        
        height := FixMenuBar;                     {Set sizes of menus       }
        
        { Rather than drawing menu bar here, I rely on FixFrontW to do it first
        time through event loop. }
   end;    {of SetUpMenus}
